<?php
require("include/general.inc.php");
include("include/header.inc.php");
$menu_symptomsuche = "style='background-color: " . $menu_aktivfarbe . "'";
include("include/menu.inc.php");
?>
<h2>Symptomsuche:</h2>

<?php
// den folgenden Teil nur anzeigen, wenn die Suche noch nicht abgeschickt wurde
if (!isset($_POST['submit'])) {
    ?>
    <h3>Bitte wählen Sie die in Frage kommenden Symptome für die Suche aus:</h3>
    <form action="<?= $_SERVER['PHP_SELF'] ?>" method="post">
        <input type="checkbox" id="symptom0" name="symptom[]" value="muedigkeit"><label
                for="symptom0">:M&uuml;digkeit</label><br/>
        <input type="checkbox" id="symptom1" name="symptom[]" value="anaemie"><label for="symptom1">:An&auml;mie</label><br/>
        <input type="checkbox" id="symptom2" name="symptom[]" value="verzoegerte_motorische_entwicklung"><label
                for="symptom2">:Verz&ouml;gerte motorische Entwicklung</label><br/>
        <input type="checkbox" id="symptom3" name="symptom[]" value="schwerer_husten"><label for="symptom3">:Schwerer
            Husten</label><br/>
        <input type="checkbox" id="symptom4" name="symptom[]" value="muskelschwund"><label
                for="symptom4">:Muskelschwund</label><br/>
        <input type="checkbox" id="symptom5" name="symptom[]" value="ueberstarke_blutungen"><label for="symptom5">:&Uuml;berstarke
            Blutung</label><br/>
        <input type="checkbox" id="symptom6" name="symptom[]" value="geistige_beeintraechtigung"><label for="symptom6">:Geistige
            Beeintr&auml;chtigung</label><br/>
        <input type="checkbox" id="symptom7" name="symptom[]" value="hautungewoehnlichkeiten"><label for="symptom7">:Hautungew&ouml;hnlichkeiten</label><br/>
        <input type="checkbox" id="symptom8" name="symptom[]" value="bewegungsstoerungen"><label for="symptom8">:Bewegungsstörungen</label><br/>
        <input type="checkbox" id="symptom9" name="symptom[]" value="anfaellig_fuer_infektionen"><label for="symptom9">:Anfällig
            für Infektionen</label><br/>
        <input type="checkbox" id="symptom10" name="symptom[]" value="haeufige_verletzungen"><label for="symptom10">:Häufige
            Verletzungen</label><br/>
        <input type="checkbox" id="symptom11" name="symptom[]" value="xanthome"><label for="symptom11">:Xanthome</label><br/>
        <input type="checkbox" id="symptom12" name="symptom[]" value="fettablagerung"><label for="symptom12">:Fettablagerung,
            z.B. am Auge oder Sehnen</label><br/>
        <input type="checkbox" id="symptom13" name="symptom[]" value="verdauungsprobleme"><label for="symptom13">:Verdauungsprobleme</label><br/>
        </br></br>
        <button type="reset">Eingaben zur&uuml;cksetzen</button>
        <br/>
        <button type="submit" name="submit" value="submit">Eingaben absenden</button>
    </form>

    <?php
// bis hier nur anzeigen, falls noch nicht abgeschickt
} else {   // sonst hole die Eingaben und berechne welche Symptome übereinstimmen mit den krankheiten
    $symptome = $_POST['symptom'];

    // Funktion vorbereiten zum Sortieren nach Anzahl der übereinstimmenden Symptome
    function sortme($krank_a, $krank_b)
    {
        return count($krank_b) - count($krank_a); // zähle Anzahl in Array a und ziehe anzahl von array b ab, gib Wert zurück (positiv oder negativ - hoch oder runter )
    }

    // Vergleiche jede Krankheit mit ihren Symptomen mit den von dem Seitenbenutzer angeklickten Symptomen
    foreach ($krankheiten as $krankheit => $value) {
        $match[$krankheit] = array_intersect($symptome, $value['symptome']);  // suche Übereinstimmungen, stecke sie in neues Array
        $unmatch[$krankheit] = array_diff($symptome, $value['symptome']); // suche die fehlenden angeklickten Symptome für die Krenkheit (nicht-Übereinstimmungen), stecke sie in neues Array
        $unmatch2[$krankheit] = array_diff($value['symptome'], $symptome); // suche die fehlenden Symptome für die Krankheit (nicht angeklickt, fehlend), stecke sie in neues Array
    }
    // Sortiere Array mit den Matches nach Anzahl der Übereinstimmungen (wahrscheinliche nach oben) - mit Funktion sortme
    uasort($match, "sortme");

    // Jetzt Ausgabe vorbereiten
    print ("<h3>Vielen Dank. Sie haben folgende " . count($symptome) . " Symptome ausgewählt:</h3>");
    // baue mir eine schöne Liste und gib den richtigen Namen der Krankheit aus
    foreach ($symptome as $key => $value) {
        print "<li>" . $symptomliste[$value] . "</li><br />"; // $symptomliste ist definiert in general.inc.php
    }
    print ("<br/><h3>Auf Grundlage der ausgewählten Symptome kommen von den 10 vorausgewählten Krankheiten folgende in Frage:</h3><table id='symptome'><tr><th>Krankheit</th><th>% Übereinstimmung <br><span class='klein'>mit ausgewählten Symptomen</span></th><th>Übereinstimmende Symptome</th><th>Ausgewählte Symptome, <br>die nicht passen</th><th>Weitere häufige Symptome<br><span class='klein'>(nicht ausgewählt)</span></th><th>Link</th></tr>");
    // Array durchlaufen, Tabelle bauen und füllen
    foreach ($match as $key => $value) {
        if (count($value) == 0) {
            break;
        } // sobald keine Übereinstimmung mit Symptomen mehr, direkt Schleife verlassen

        print ("<tr><td>" . $krankheiten[$key]['name'] . "</td>");
        print ("<td>" . round(count($value) / count($symptome) * 100) . " % </td>");
        print ("<td>" . count($value) . ": " . array_liste($match[$key]) . "</td>");
        print ("<td>" . count($unmatch[$key]) . ": " . array_liste($unmatch[$key]) . "</td>");
        print ("<td>" . count($unmatch2[$key]) . ": " . array_liste($unmatch2[$key]) . "</td>");
        print ("<td><a href='" . $krankheiten[$key]['link'] . "' target='_blank'>Link</a></td>");
        print ("</tr>");
    }
    print ("</table>");

}

?>




<?php
include("include/footer.inc.php");
?>